// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Dbcommon.pas' rev: 10.00

#ifndef DbcommonHPP
#define DbcommonHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <Variants.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Db.hpp>	// Pascal unit
#include <Sqltimst.hpp>	// Pascal unit
#include <Strutils.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Dbcommon
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TCANOperator { coNOTDEFINED, coISBLANK, coNOTBLANK, coEQ, coNE, coGT, coLT, coGE, coLE, coNOT, coAND, coOR, coTUPLE2, coFIELD2, coCONST2, coMINUS, coADD, coSUB, coMUL, coDIV, coMOD, coREM, coSUM, coCOUNT, coMIN, coMAX, coAVG, coCONT, coUDF2, coCONTINUE2, coLIKE, coIN, coLIST2, coUPPER, coLOWER, coFUNC2, coLISTELEM2, coASSIGN };
#pragma option pop

#pragma option push -b-
enum NODEClass { nodeNULL, nodeUNARY, nodeBINARY, nodeCOMPARE, nodeFIELD, nodeCONST, nodeTUPLE, nodeCONTINUE, nodeUDF, nodeLIST, nodeFUNC, nodeLISTELEM };
#pragma option pop

typedef DynamicArray<Byte >  TExprData;

typedef Byte TFieldMap[42];

#pragma option push -b-
enum TParserOption { poExtSyntax, poAggregate, poDefaultExpr, poUseOrigNames, poFieldNameGiven, poFieldDepend };
#pragma option pop

typedef Set<TParserOption, poExtSyntax, poFieldDepend>  TParserOptions;

#pragma option push -b-
enum TExprNodeKind { enField, enConst, enOperator, enFunc };
#pragma option pop

#pragma option push -b-
enum TExprScopeKind { skField, skAgg, skConst };
#pragma option pop

struct TExprNode;
typedef TExprNode *PExprNode;

struct TExprNode
{
	
public:
	TExprNode *FNext;
	TExprNodeKind FKind;
	bool FPartial;
	TCANOperator FOperator;
	Variant FData;
	TExprNode *FLeft;
	TExprNode *FRight;
	Db::TFieldType FDataType;
	int FDataSize;
	Classes::TList* FArgs;
	TExprScopeKind FScopeKind;
} ;

class DELPHICLASS TFilterExpr;
class PASCALIMPLEMENTATION TFilterExpr : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Db::TDataSet* FDataSet;
	Byte FFieldMap[42];
	Db::TFilterOptions FOptions;
	TParserOptions FParserOptions;
	TExprNode *FNodes;
	DynamicArray<Byte >  FExprBuffer;
	int FExprBufSize;
	int FExprNodeSize;
	int FExprDataSize;
	WideString FFieldName;
	Classes::TBits* FDependentFields;
	Db::TField* __fastcall FieldFromNode(PExprNode Node);
	char * __fastcall GetExprData(int Pos, int Size);
	int __fastcall PutConstBCD(const Variant &Value, int Decimals);
	int __fastcall PutConstFMTBCD(const Variant &Value, int Decimals);
	int __fastcall PutConstBool(const Variant &Value);
	int __fastcall PutConstDate(const Variant &Value);
	int __fastcall PutConstDateTime(const Variant &Value);
	int __fastcall PutConstSQLTimeStamp(const Variant &Value);
	int __fastcall PutConstFloat(const Variant &Value);
	int __fastcall PutConstInt(Db::TFieldType DataType, const Variant &Value);
	int __fastcall PutConstInt64(Db::TFieldType DataType, const Variant &Value);
	int __fastcall PutConstNode(Db::TFieldType DataType, char * Data, int Size);
	int __fastcall PutConstStr(const AnsiString Value);
	int __fastcall PutConstTime(const Variant &Value);
	int __fastcall PutData(char * Data, int Size);
	int __fastcall PutExprNode(PExprNode Node, TCANOperator ParentOp);
	int __fastcall PutFieldNode(Db::TField* Field, PExprNode Node);
	int __fastcall PutNode(NODEClass NodeType, TCANOperator OpType, int OpCount);
	void __fastcall SetNodeOp(int Node, int Index, int Data);
	int __fastcall PutConstant(PExprNode Node);
	Db::TField* __fastcall GetFieldByName(WideString Name);
	
public:
	__fastcall TFilterExpr(Db::TDataSet* DataSet, Db::TFilterOptions Options, TParserOptions ParseOptions, const WideString FieldName, Classes::TBits* DepFields, Byte * FieldMap);
	__fastcall virtual ~TFilterExpr(void);
	PExprNode __fastcall NewCompareNode(Db::TField* Field, TCANOperator Operator, const Variant &Value);
	PExprNode __fastcall NewNode(TExprNodeKind Kind, TCANOperator Operator, const Variant &Data, PExprNode Left, PExprNode Right);
	TExprData __fastcall GetFilterData(PExprNode Root);
	__property Db::TDataSet* DataSet = {write=FDataSet};
};


#pragma option push -b-
enum TExprToken { etEnd, etSymbol, etName, etLiteral, etLParen, etRParen, etEQ, etNE, etGE, etLE, etGT, etLT, etADD, etSUB, etMUL, etDIV, etComma, etLIKE, etISNULL, etISNOTNULL, etIN };
#pragma option pop

class DELPHICLASS TExprParser;
class PASCALIMPLEMENTATION TExprParser : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	WideChar FDecimalSeparator;
	TFilterExpr* FFilter;
	Byte FFieldMap[42];
	WideString FText;
	WideChar *FSourcePtr;
	WideChar *FTokenPtr;
	WideString FTokenString;
	WideString FStrTrue;
	WideString FStrFalse;
	TExprToken FToken;
	TExprToken FPrevToken;
	DynamicArray<Byte >  FFilterData;
	bool FNumericLit;
	int FDataSize;
	TParserOptions FParserOptions;
	WideString FFieldName;
	Db::TDataSet* FDataSet;
	Classes::TBits* FDependentFields;
	void __fastcall NextToken(void);
	bool __fastcall NextTokenIsLParen(void);
	PExprNode __fastcall ParseExpr(void);
	PExprNode __fastcall ParseExpr2(void);
	PExprNode __fastcall ParseExpr3(void);
	PExprNode __fastcall ParseExpr4(void);
	PExprNode __fastcall ParseExpr5(void);
	PExprNode __fastcall ParseExpr6(void);
	PExprNode __fastcall ParseExpr7(void);
	WideString __fastcall TokenName();
	bool __fastcall TokenSymbolIs(const WideString S);
	bool __fastcall TokenSymbolIsFunc(const WideString S);
	void __fastcall GetFuncResultInfo(PExprNode Node);
	void __fastcall TypeCheckArithOp(PExprNode Node);
	void __fastcall GetScopeKind(PExprNode Root, PExprNode Left, PExprNode Right);
	
public:
	__fastcall TExprParser(Db::TDataSet* DataSet, const WideString Text, Db::TFilterOptions Options, TParserOptions ParserOptions, const WideString FieldName, Classes::TBits* DepFields, Byte * FieldMap);
	__fastcall virtual ~TExprParser(void);
	void __fastcall SetExprParams(const WideString Text, Db::TFilterOptions Options, TParserOptions ParserOptions, const WideString FieldName);
	__property TExprData FilterData = {read=FFilterData};
	__property int DataSize = {read=FDataSize, nodefault};
};


struct TFieldInfo
{
	
public:
	WideString DatabaseName;
	WideString TableName;
	WideString OriginalFieldName;
} ;

#pragma option push -b-
enum TSQLToken { stUnknown, stTableName, stFieldName, stAscending, stDescending, stSelect, stFrom, stWhere, stGroupBy, stHaving, stUnion, stPlan, stOrderBy, stForUpdate, stEnd, stPredicate, stValue, stIsNull, stIsNotNull, stLike, stAnd, stOr, stNumber, stAllFields, stComment, stDistinct };
#pragma option pop

//-- var, const, procedure ---------------------------------------------------
static const Shortint CANEXPRSIZE = 0xa;
static const Shortint CANHDRSIZE = 0x8;
static const Shortint CANEXPRVERSION = 0x2;
#define SQLSections (Set<TSQLToken, stUnknown, stDistinct> () << TSQLToken(5) << TSQLToken(6) << TSQLToken(7) << TSQLToken(8) << TSQLToken(9) << TSQLToken(10) << TSQLToken(11) << TSQLToken(12) << TSQLToken(13) )
extern PACKAGE TSQLToken __fastcall NextSQLToken(char * &p, /* out */ AnsiString &Token, TSQLToken CurSection)/* overload */;
extern PACKAGE TSQLToken __fastcall NextSQLToken(WideChar * &p, /* out */ WideString &Token, TSQLToken CurSection)/* overload */;
extern PACKAGE WideString __fastcall AddParamSQLForDetail(Db::TParams* Params, WideString SQL, bool Native, WideString QuoteChar = L"");
extern PACKAGE WideString __fastcall GetTableNameFromQuery(const WideString SQL);
extern PACKAGE WideString __fastcall GetTableNameFromSQL(const WideString SQL);
extern PACKAGE bool __fastcall IsMultiTableQuery(const WideString SQL);
extern PACKAGE bool __fastcall SQLRequiresParams(const WideString SQL);
extern PACKAGE Db::TIndexDef* __fastcall GetIndexForOrderBy(const WideString SQL, Db::TDataSet* DataSet);
extern PACKAGE bool __fastcall GetFieldInfo(const WideString Origin, TFieldInfo &FieldInfo);

}	/* namespace Dbcommon */
using namespace Dbcommon;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Dbcommon
